var themeManager = (function () {
  'use strict'; 
  var csInterface = new CSInterface();

  /* Convert the Color object to string in hexadecimal format; */
  function toHex(color, delta) {
    function computeValue(value, delta) {
      var computedValue = !isNaN(delta) ? value + delta : value;
      if (computedValue < 0) {
        computedValue = 0;
      } else if (computedValue > 255) {
        computedValue = 255;
      }            
      computedValue = Math.floor(computedValue);
      computedValue = computedValue.toString(16);
      return computedValue.length === 1 ? "0" + computedValue : computedValue;
    } 
    var hex = "";
    if (color) {
      hex = computeValue(color.red, delta) + computeValue(color.green, delta) + computeValue(color.blue, delta);
    }
    return hex;
  }

  //
  function insertRule(stylesheetId, selector, rule) {
    var stylesheet = document.getElementById(stylesheetId);   
    if (stylesheet) {
      stylesheet = stylesheet.sheet;
      stylesheet.insertRule(selector + ' { ' + rule + ' }', stylesheet.cssRules.length);
    }
  }

  /* Update the theme with the AppSkinInfo retrieved from the host product. */
  function updateThemeWithAppSkinInfo(appSkinInfo) {
    var fontColor;
    var styleId = "hostStyle";
    var sentinelColor = appSkinInfo.panelBackgroundColor.color.red;
    var themeIsLight = sentinelColor > 128;

    if (sentinelColor > 200) { // exact: 240 (#D6D6D6)
    
      document.getElementById('theme').href = "css/superlight.css";
        
        $('#i_dodge').attr('src','img/icons/dodge_tool_light.png');
		$('#i_burn').attr('src','img/icons/burn_tool_light.png');
		$('#i_brush').attr('src','img/icons/brush_tool_light.png');
        $('#i_brush3').attr('src','img/icons/brush_tool_light.png');
		$('#i_heal').attr('src','img/icons/heal_tool_light.png');
        $('#i_heal3').attr('src','img/icons/heal_tool_light.png');
		$('#i_heal2').attr('src','img/icons/heal_tool_light_2.png');
        $('#i_heal23').attr('src','img/icons/heal_tool_light_2.png');
		$('#i_mixer').attr('src','img/icons/mixBrush_tool_light.png');
        $('#i_mixer3').attr('src','img/icons/mixBrush_tool_light.png');
		$('#i_patch').attr('src','img/icons/patch_tool_light.png');
        $('#i_patch3').attr('src','img/icons/patch_tool_light.png');
		$('#i_clone').attr('src','img/icons/clone_tool_light.png');
        $('#i_clone3').attr('src','img/icons/clone_tool_light.png');
        $('#Tutorials').attr('src','img/icons/tuts_light.png'); 
        $('#CRW').attr('src','img/icons/crw_light.png'); 
        $('#HELP').attr('src','img/icons/help_light.png'); 
        $('#LIKE').attr('src','img/icons/like_light.png');
        
    } else if (sentinelColor > 180) { // exact: 184 (#B8B8B8)
       
     document.getElementById('theme').href = "css/light.css";
        
        $('#i_dodge').attr('src','img/icons/dodge_tool_light.png');
		$('#i_burn').attr('src','img/icons/burn_tool_light.png');
		$('#i_brush').attr('src','img/icons/brush_tool_light.png');
        $('#i_brush3').attr('src','img/icons/brush_tool_light.png');
		$('#i_heal').attr('src','img/icons/heal_tool_light.png');
        $('#i_heal3').attr('src','img/icons/heal_tool_light.png');
		$('#i_heal2').attr('src','img/icons/heal_tool_light_2.png');
        $('#i_heal23').attr('src','img/icons/heal_tool_light_2.png');
		$('#i_mixer').attr('src','img/icons/mixBrush_tool_light.png');
        $('#i_mixer3').attr('src','img/icons/mixBrush_tool_light.png');
		$('#i_patch').attr('src','img/icons/patch_tool_light.png');
        $('#i_patch3').attr('src','img/icons/patch_tool_light.png');
		$('#i_clone').attr('src','img/icons/clone_tool_light.png');
        $('#i_clone3').attr('src','img/icons/clone_tool_light.png');
        $('#Tutorials').attr('src','img/icons/tuts_light.png'); 
        $('#CRW').attr('src','img/icons/crw_light.png');
        $('#HELP').attr('src','img/icons/help_light.png'); 
        $('#LIKE').attr('src','img/icons/like_light.png');
        
    } else if (sentinelColor > 80) { // exact: 83 (#535353)
      document.getElementById('theme').href = "css/dark.css";
        
        $('#i_dodge').attr('src','img/icons/dodge_tool_dark.png');
		$('#i_burn').attr('src','img/icons/burn_tool_dark.png');
		$('#i_brush').attr('src','img/icons/brush_tool_dark.png');
        $('#i_brush3').attr('src','img/icons/brush_tool_dark.png');
		$('#i_heal').attr('src','img/icons/heal_tool_dark.png');
        $('#i_heal3').attr('src','img/icons/heal_tool_dark.png');
		$('#i_heal2').attr('src','img/icons/heal_tool_dark_2.png');
        $('#i_heal23').attr('src','img/icons/heal_tool_dark_2.png');
		$('#i_mixer').attr('src','img/icons/mixBrush_tool_dark.png');
        $('#i_mixer3').attr('src','img/icons/mixBrush_tool_dark.png');
		$('#i_patch').attr('src','img/icons/patch_tool_dark.png');
        $('#i_patch3').attr('src','img/icons/patch_tool_dark.png');
		$('#i_clone').attr('src','img/icons/clone_tool_dark.png');
        $('#i_clone3').attr('src','img/icons/clone_tool_dark.png');
        $('#Tutorials').attr('src','img/icons/tuts_dark.png'); 
        $('#CRW').attr('src','img/icons/crw_dark.png'); 
        $('#HELP').attr('src','img/icons/help_dark.png'); 
        $('#LIKE').attr('src','img/icons/like_dark.png'); 
        
    } else if (sentinelColor >= 50) { // exact: 52 (#343434)
      document.getElementById('theme').href = "css/superdark.css";
        
        $('#i_dodge').attr('src','img/icons/dodge_tool_dark.png');
		$('#i_burn').attr('src','img/icons/burn_tool_dark.png');
		$('#i_brush').attr('src','img/icons/brush_tool_dark.png');
        $('#i_brush3').attr('src','img/icons/brush_tool_dark.png');
		$('#i_heal').attr('src','img/icons/heal_tool_dark.png');
        $('#i_heal3').attr('src','img/icons/heal_tool_dark.png');
		$('#i_heal2').attr('src','img/icons/heal_tool_dark_2.png');
        $('#i_heal23').attr('src','img/icons/heal_tool_dark_2.png');
		$('#i_mixer').attr('src','img/icons/mixBrush_tool_dark.png');
        $('#i_mixer3').attr('src','img/icons/mixBrush_tool_dark.png');
		$('#i_patch').attr('src','img/icons/patch_tool_dark.png');
        $('#i_patch3').attr('src','img/icons/patch_tool_dark.png');
		$('#i_clone').attr('src','img/icons/clone_tool_dark.png');
        $('#i_clone3').attr('src','img/icons/clone_tool_dark.png');    
        $('#Tutorials').attr('src','img/icons/tuts_dark.png');
        $('#CRW').attr('src','img/icons/crw_dark.png'); 
        $('#HELP').attr('src','img/icons/help_dark.png'); 
        $('#LIKE').attr('src','img/icons/like_dark.png'); 
    }
    

      
    fontColor = (themeIsLight) ? "333" : "DDD";

    // Add your rules here in styles.css, which being
    // loaded after Topcoat, overrides these selectors
    insertRule(styleId, "body", "color:" + "#" + fontColor);
  }

  function onAppThemeColorChanged(event) {
    var appSkinInfo = csInterface.getHostEnvironment().appSkinInfo;
    updateThemeWithAppSkinInfo(appSkinInfo);
  }

  function init() {     
    var appSkinInfo = csInterface.getHostEnvironment().appSkinInfo;
    updateThemeWithAppSkinInfo(appSkinInfo);
    csInterface.addEventListener(CSInterface.THEME_COLOR_CHANGED_EVENT, onAppThemeColorChanged);
  }

  return {
    init: init
  };

}());